#!/bin/bash

#set variables
i2=0
sku='9781625798022'
#CHANGE line 38 TOO
filename="NCH-line.html"
title="Notes on the Carreraverse"
underscore_title="Notes_on_the_Carreraverse"
publisher="Baen Books"
copyright="© 2020 by Tom Kratman"
author="Baen Books"
author_sort="Books, Baen"
chapters=4

#ISBN10="1451637470"
#ISBN13='9781451637472'
#ISBN10_Trade='1-4516-3747-0'
#ISBN13_Trade='978-1-4516-3747-2'
EISBN="9781625798022"  
EISBN_Trade="978-1-62579-802-2"  
#art_by="NASA Image Exchange"
#art_by_sort="Image Exchange, NASA"
subject="Nonfiction"
publish_date='2020-12-15'
#first_printing="1995"
type_book='Nonfiction'
cover_type="Ebook"

i5=$chapters
toc_name="$sku""_toc.htm"
toc_name2="$sku""_toc.htm.new"
cover_name="$sku""__c_.htm"
next="$sku""___""1"".htm"
frame_name="$sku"".htm"
cfile="./chapters.txt"
chapterData= "0"
#delete chapters file -- added Nov 2010 AKV
echo "test"
if [ -f $cfile ]
then 
	rm $cfile
fi


#seperate chapters
awk -F '"' 'BEGIN {i=0; sku="9781625798022"}{ 

       if( $2 == "chapter" ) 
       { 
	 close(name);
        # Print added Nov 2010 AKV

        print (substr( $0, index($0,$3)+1, length($0) - index($0,$3) - 4) ) >> "chapters.txt"
	i = i + 1;
	print NR
      
	}
	if( i < 10 )
	{
	   name = sku "___" i ".htm"
	}
	else
	{
           name = sku "__" i ".htm"
	}
#change & to &amp;
        gsub ("\b&\b","&amp;")
	print >> name
      }' $filename


#generate table of contents


echo -e "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n
<!DOCTYPE html PUBLIC \"+//ISBN 0-9673008-1-9//DTD OEB 1.2 Document//EN\" \"http://openebook.org/dtds/oeb-1.2/oebdoc12.dtd\"> \n \
<html xml:lang=\"en-us\" xmlns=\"http://www.w3.org/1999/xhtml\"> \n \
<head><meta http-equiv=\"Content-Type\" content=\"text/html;\" /> \n \
<title>$title</title> \n \
<meta name=\"Publisher\" content=\"$publisher\" /> \n \
<meta name=\"Copyright\" content=\"$copyright\" /> \n \
<meta name=\"Author\" content=\"$author\" /> \n \
<style type=\"text/css\"> \n \
  p {text-indent:2em;margin-top:0;margin-bottom:2px} \n \
  h1 {page-break-before:left} \n \
</style> \n \
<script type=\"text/javascript\" language=\"javascript\"><!-- \n \
function setStyle() \n \
{ \n \
  if (parent.control) if (parent.control.mainLoad) parent.control.mainLoad(document); \n \
  if (window.focus) window.focus(); \n \
} \n \
function PNo(PgNo) \n \
{ \n \
  if (parent.control) if (parent.control.SetPage) parent.control.document.forms[0].PageNo.value = PgNo; \n \
} \n \
setStyle(); \n \
//--></script> \n \
</head> \n \
<body onload=\"setStyle()\" > \n \
<p style=\"text-align: right\"><a href=\"$cover_name\">Back</a> | <a href=\"$next\">Next</a><br /><a href=\"$toc\">Contents</a></p> \n \
<h1 align=\"center\">$title</h1> \n \
<h2 align=\"center\">Table of Contents</h2>" > $toc_name

# Next section added Nov 2010 - AKV loads chapters.txt to an array
myfile="chapters.txt"
myarray=()
myidx=1
while read line
do 
	myarray[$myidx]=$line
	#echo "myidx" $myidx $line ${myarray[$myidx]}
	myidx=$(( $myidx + 1 ))
        
done < $myfile

i5=1
while [ $i5 -le $chapters ]
do

	if [ $i5 -lt 10 ]
	then
	   toc_ref="$sku""___""$i5"".htm"

	else
		toc_ref="$sku""__""$i5"".htm"
	fi
                echo $i5
# added Ctitle Nov 2010 AKV
		ctitle=${myarray[$i5])}
		echo	-e "<a href=\"$toc_ref\"><b>$ctitle</b></a><br />"  >> $toc_name
					
		i5=$(( $i5 + 1 ))
done				


echo 	-e	"<p style=\"text-align: right\"><a href=\"$cover_name\">Back</a> | <a href=\"$next\">Next</a></p> \n \
</body> \n \
</html>" >> $toc_name

	

#add header and footer to chapters
while [ $i2 -le $chapters ]
do
	echo $i2
# added Ctitle Nov 2010 AKV
		ctitle=${myarray[$i2])}
	i3=$(( $i2 + 1 ))
	i4=$(( $i2 - 1 ))
	if [ $i3 -lt 10 ]
	then
	   next="$sku""___""$i3"".htm"
	else
		next="$sku""__""$i3"".htm"
	fi
	
	if [ $chapters -lt $i3 ]
	then
		next="$sku""__c_"".htm"
	fi
	
	if [ $i4 -lt 10 ]
	then
	   back="$sku""___""$i4"".htm"
	else
		back="$sku""__""$i4"".htm"
	fi


	if [ $i2 -lt 10 ]
	then
	   name="$sku""___""$i2"".htm"
	else
		name="$sku""__""$i2"".htm"
	fi
	
	if [ $i4 -eq 0 ]
	then
		back="$sku""__c_"".htm"
	fi
		
	
	echo $name
	
	name2="$name"".new"

	
	
	sed		"1i\\
				<?xml version=\"1.0\" encoding=\"UTF-8\"?> \\
						<!DOCTYPE html PUBLIC \"+//ISBN 0-9673008-1-9//DTD OEB 1.2 Document//EN\" \"http://openebook.org/dtds/oeb-1.2/oebdoc12.dtd\"> \\
						<html xml:lang=\"en-us\" xmlns=\"http://www.w3.org/1999/xhtml\"> \\
						<head><meta http-equiv=\"Content-Type\" content=\"text/html;\" /> \\
						<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"> \\
						<title>  - $ctitle</title> \\
						<meta name=\"Publisher\" content=\"$publisher\" /> \\
						<meta name=\"Copyright\" content=\"$copyright\" /> \\
						<meta name=\"Author\" content=\"$author\" /> \\
						<style type=\"text/css\"> \\
						  p {text-indent:2em;margin-top:0;margin-bottom:2px} \\
						  h1 {page-break-before:left} \\
						  p.chapter {margin: 135.0px 0.0px 8.0px 0.0px; text-indent: 0; line-height: 24.1px; font: 28.0px 'Times New Roman'; color: #2e2829; font-weight:bold; text-align:center;} \\
					  	p.p1 {margin: 30.0px 0.0px 30.0px 0.0px; text-align: center; text-indent: 0.0px; font-size: 200%;} \\
	p.p2 {margin: 30.0px 0.0px 0.0px 0.0px; text-align: center; text-indent: 0.0px; font-size: 125%;} \\
	p.p3 {margin: 0.0px 0.0px 30.0px 0.0px; text-align: center; text-indent: 0.0px; font-size: 115%;} \\
	p.p4 {margin: 0.0px 0.0px 0.0px 0.0px; min-height: 16.0px;} \\
	p.p5 { text-align: center; text-indent: 0.0px; } \\
	p.p6 {  text-indent: 0.0px; } \\
	p.p8 {margin: 8.0px 0.0px 8.0px 0.0px; text-align: center; text-indent: 0.0px; } \\
	p.p9 { text-align: left; text-indent: 0.0px; font-size: 85%;} \\
	p.p10 { text-align: right; text-indent: 0.0px; } \\
	p.p20 {margin: 0.0px 4em 2.0px 4em;  text-indent: 0.0px; } \\
	p.p47 {margin: 0.0px 0.0px 2.0px 2em;  text-indent: 0.0px; } \\
	p.p12 { text-indent: -2.0em; margin-left: 3em;} \\
	p.p13 {text-indent: 0.0px; text-align: left} \\
	p.p14 {margin: 8px 0.0px 0px 0.0px;} \\
	span.s5 {word-spacing: 8.0px;} \\
	span.s1 {text-decoration: underline;} \\
	img {max-width: 100%; max-height: auto;} \\
	ul {list-style-type: disc;} \\
	hr.hr1{border: 1px solid black;} \\
						</style> \\
						<script type=\"text/javascript\" language=\"javascript\"><!-- \\
						function setStyle() \\
						{ \\
						  if (parent.control) if (parent.control.mainLoad) parent.control.mainLoad(document); \\
						  if (window.focus) window.focus(); \\
						} \\
						function PNo(PgNo) \\
						{ \\
						  if (parent.control) if (parent.control.SetPage) parent.control.document.forms[0].PageNo.value = PgNo; \\
						} \\
						setStyle(); \\
						//--></script> \\
						</head> \\
						<body onload=\"setStyle()\" > \\
						<p style=\"text-align: right\"><a href=\"$back\">Back</a> | <a href=\"$next\">Next</a><br /><a href=\"$toc_name\">Contents</a></p>" $name > $name2
	rm $name
	mv $name2 $name
	
echo "<p style=\"text-align: right\"><a href=\"$back\">Back</a> | <a href=\"$next\">Next</a><br /><a href=\"$frame_name\" target=\"_top\">Framed</a></p> </body></html>" >> $name

	
	i2=$(( $i2 + 1 ))
done

#generate frame
underscore_title_name="$underscore_title"".htm"
frameless="$sku""__c_.htm"
i6=1

echo -en "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n \
<!DOCTYPE html PUBLIC \"+//ISBN 0-9673008-1-9//DTD OEB 1.2 Document//EN\" \"http://openebook.org/dtds/oeb-1.2/oebdoc12.dtd\"> \n \
<html xml:lang=\"en-US\" xmlns=\"http://www.w3.org/1999/xhtml\"> \n \
<head> \n \
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /> \n \
<meta http-equiv=\"pragma\" content=\"no-cache\" /> \n \
<title>$title by $author - $publisher</title> \n \

<script language=\"JavaScript\"><!-- \n \
  // This frame remembers the state of all the other frames \n \

  var FrameVersion = '2.0.1.0'; \n \
  // enter the Isbn of the book here \n \
  var isbn = '$sku'; \n \

  // Enter the array of last paragraph numbers by chapter \n \
  // the first entry is non-zero only if their is a prologue \n
var lastPg = new Array(0" >> $frame_name

while [ $i6 -le $chapters ]
do
	if [ $i6 -lt 10 ]
	then
		toc_filename="$sku""___""$i6"".htm"
	else
		toc_filename="$sku""__""$i6"".htm"
	fi

	last_line_no=`cat $toc_filename | grep '<a id="p' | awk 'BEGIN { FS = "[p\"]+" } END { print $2 }'`
	
	chapterData+=","
	chapterData+=$last_line_no
	echo -n "," >> $frame_name
	echo -n $last_line_no >> $frame_name
	i6=$(( $i6 + 1 ))
done

echo -en  "); \n \

  // Enter the title above \n \
  var TheBookTitle = document.title; \n \

//--></script> \n \
 
<script language=\"JavaScript\"><!-- \n \
  if (window.focus) window.focus(); \n \
//--></script> \n \

</head> \n \

<frameset framespacing=\"0\" border=\"0\" frameborder=\"0\" rows=\"25,*\"> \n \
  <frame name=\"banner\" scrolling=\"no\" noresize marginwidth=\"0\" marginheight=\"0\" src=\"banner.htm\" target=\"_self\"> \n \
  <frameset cols=\"114,*\"> \n \
    <frame name=\"control\" target=\"main\" src=\"bncontrol.htm\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\" style=\"padding-left: 0; padding-top: 0\"> \n \
    <frame name=\"main\" target=\"_self\" marginwidth=\"20\" marginheight=\"5\" scrolling=\"auto\" src=\"$frameless\"> \n \
  </frameset> \n \
  <noframes> \n \
  <body> \n \

  <p style=\"text-align: center\">This page uses frames, but your browser doesn't support them.<br /> \n \
  &nbsp;<a href=\"$frameless\">Click here for frameless version</a></p> \n \

  </body> \n \
  </noframes> \n \
</frameset> \n \

</html>" >> $frame_name
cp $frame_name $underscore_title_name


echo -e "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n \
<html xml:lang=\"en-US\" xmlns=\"http://www.w3.org/1999/xhtml\"> \n \
<head> \n \
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1252\" /> \n \
<title></title> \n \
</head> \n \
<body style=\"color:#FFFF00; background-color:#000000; margin-top:0;\"> \n \
<h5 style='padding:3px;padding-left:10px;color:rgb(255,201,0);font-family:sans-serif'>"$title" by "$author" - "$publisher"</h5>\n
</body> \n \
</html> \n \
" > banner.htm



#generate OPF file
opf_name="$sku"".opf"


echo -en "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n \
<!DOCTYPE package PUBLIC \"+//ISBN 0-9673008-1-9//DTD OEB 1.0.1 Package//EN\" \"http://openebook.org/dtds/oeb-1.0.1/oebpkg101.dtd\"> \n \
<package xmlns=\"http://openebook.org/namespaces/oeb-package/1.0/\" unique-identifier=\"DOI-$author\"> \n \
  <metadata> \n \
    <dc-metadata xmlns:dc=\"http://purl.org/dc/elements/1.0/\" xmlns:oebpackage=\"http://openebook.org/namespaces/oeb-package/1.0/\"> \n \
      <dc:Title>$title</dc:Title> \n \
      <dc:Type>$type_book</dc:Type> \n \
      <dc:Identifier id=\"EISBN-$EISBN\" scheme=\"EISBN-Trade\">$EISBN_Trade</dc:Identifier> \n \
      <dc:Identifier id=\"DOI-$sku\" scheme=\"DOI\">10.1125/Baen.$sku</dc:Identifier> \n \
      <dc:Publisher>$publisher</dc:Publisher> \n \
      <dc:Creator role=\"aut\" file-as=\"$author_sort\">$art</dc:Creator> \n \
      <dc:Contributor role=\"art\" file-as=\"$art_by_sort\">$art_by</dc:Contributor> \n \
      <dc:Subject>$subject</dc:Subject> \n \
      <dc:Rights>$copyright</dc:Rights> \n \
      <dc:Date>$publish_date</dc:Date> \n \
      <dc:Language>en-us</dc:Language> \n \
    </dc-metadata> \n \
    <x-metadata> \n \
    </x-metadata> \n \
  </metadata> \n \
  <manifest> \n \
   <item id=\"content\" href=\""$sku"__p_.htm\" media-type=\"text/x-oeb1-document\" /> \n \
	<item id=\"toc\" href=\""$sku"_toc.htm\" media-type=\"text/x-oeb1-document\" /> \n \
	<item id=\"coverstandard\" href=\""$sku"_Cover.jpg\" media-type=\"image/jpeg\" /> \n \
	<item id=\"thumbstandard\" href=\""$sku"_Library.jpg\" media-type=\"image/jpeg\" /> \n \
	<item id=\"titlestandard\" href=\""$sku"_Title.jpg\" media-type=\"image/jpeg\" /> \n \
	<item id=\"cover\" href=\""$sku"_PCCover.jpg\" media-type=\"image/jpeg\" /> \n \
	<item id=\"thumb\" href=\""$sku"_PCLibrary.jpg\" media-type=\"image/jpeg\" /> \n \
	</manifest> \n \
	<spine> \n \
	<itemref idref=\"content\" /> \n \
	</spine> \n \
	<guide> \n \
	<reference type=\"toc\" title=\"Table of Contents\" href=\""$sku"_toc.htm\" /> \n \
	<reference type=\"copyright-page\" title=\"Copyright\" href=\""$sku"__p_.htm\" /> \n \
	<reference type=\"title-page\" title=\"Title Page\" href=\""$sku"__p_.htm\" /> \n \
	<reference type=\"other.ms-firstpage\" title=\"first page\" href=\""$sku"__p_.htm#Chap_1\" /> \n \
	<reference type=\"other.ms-coverimage-standard\" title=\"cover image standard\" href=\""$sku"_Cover.jpg\" /> \n \
	<reference type=\"other.ms-thumbimage-standard\" title=\"thumb image standard\" href=\""$sku"_Library.jpg\" /> \n \
	<reference type=\"other.ms-coverimage\" title=\"PPC cover image\" href=\""$sku"_PCCover.jpg\" /> \n \
	<reference type=\"other.ms-thumbimage\" title=\"PPC thumb image\" href=\""$sku"_PCLibrary.jpg\" /> \n \
	</guide> \n \
	</package>" >> $opf_name

#generate cover file
cover_name="$sku""__c_.htm"

echo -en "<!DOCTYPE html PUBLIC \"+//ISBN 0-9673008-1-9//DTD OEB 1.0.1 Document//EN\" \"http://openebook.org/dtds/oeb-1.0.1/oebdoc101.dtd\"> \n \
<html  lang=\"en\" xmlns=\"http://www.w3.org/1999/xhtml\"> \n \
<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /> \n \
<title> </title> \n \
<meta name=\"Publisher\" content=\"$publisher\" /> \n \
<meta name=\"Copyright\" content=\"$copyright\" /> \n \
<meta name=\"author\" content=\"$author\" /> \n \
\n \
<script language=\"JavaScript\"><!-- \n \
function setStyle() \n \
{ \n \
  if (parent.control) if (parent.control.mainLoad) parent.control.mainLoad(document); \n \
  if (window.focus) window.focus(); \n \
} \n \
function PNo(PgNo) \n \
{ \n \
  if (parent.control) if (parent.control.SetPage) parent.control.document.forms[0].PageNo.value = PgNo; \n \
} \n \
setStyle(); \n \
//--></script> \n \
\n \
</head> \n \
\n \
<body onload=\"setStyle()\"   style=\"font-family:sans-serif\" > \n \
<p style=\"text-align: right\"><a href=\""$sku"_toc.htm\">Next</a></p> \n \
  <div style=\"text-align: center\"> \n \
  <table border=\"0\" width=\"95%\" cellspacing=\"4\"> \n \
    <tr> \n \
      <td valign=\"top\" align=\"left\" colspan=\"2\"> \n \
        <hr /><h1 align=\"center\">$title</h1><hr /> \n \
\n \
      <h3 align=\"center\"><img align=\"left\" border=\"0\" hspace=\"10\" src=\""$sku".jpg\" width=150px/></h3> \n \
		<p style=\"text-align: left\">Everything you ever wanted to know about the Carreraverse in one handy volume! Tom Kratman’s Carrera series has cut a swath through the military science fiction genre. Now Kratman outlines the history and worldbuilding of his popular creation.<br><br>“[Kratman is] a professional military man . . . up to speed on military and geopolitical conceits.”&mdash;Mark Steyn, best-selling author of America Alone<br><br>“Kratman raises disquieting questions on what it might take to win the war on terror . . . [with] realistic action sequences, strong characterizations, and thoughts on the philosophy of war.”&mdash;Publishers Weekly</p> \n \
      <br clear=\"all\" /><hr /> \n \
      </td> \n \
    </tr> \n \
    <tr> \n \
      <td width=\"50%\" valign=\"top\" align=\"left\"> \n \
        <p><a name=\"copyright\"></a> \n \
      <a href=\"http://www.baen.com/bookdata/catalog/orderisbn/isbn/$sku\" target=\"_blank\"> \n \
         <img src=\"buttonorder.png\" border=\"0\" alt=\"ORDER\" /></a> <b>$cover_type</b><br /> \n \
      <p>This is a work of fiction. All the characters and events portrayed in this book are fictional, and any resemblance to real people or incidents is purely coincidental.</p> \n \
    
</td> \n \
    <td width=\"50%\" valign=\"top\" align=\"left\"> \n \
      <h3>eISBN: $EISBN_Trade</h3> \n \
      <p>Copyright $copyright</p> \n \
      <p>All rights reserved, including the right to reproduce this book or portions thereof in any form.</p> \n \
      <p>Electronic version by Baen Books<br /><a href=\"http://www.baen.com\" target=\"_blank\">http://www.baen.com</a></p> \n \
    </td> \n \
  </tr> \n \
  <tr> \n \
    <td valign=\"top\" align=\"left\" colspan=\"2\"> \n \
    <hr /> \n \
    </td> \n \
  </tr> \n \
  </table> \n \
</div> \n \
<p style=\"text-align: right\"><a href=\""$sku"_toc.htm\">Next</a></p> \n \
</body> \n \
</html>" >> $cover_name

bnfile="./bncontrol.htm"
echo -en "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>
<!DOCTYPE html PUBLIC \"+//ISBN 0-9673008-1-9//DTD OEB 1.2 Document//EN\" \"http://openebook.org/dtds/oeb-1.2/oebdoc12.dtd\">
<html xml:lang=\"en-US\" xmlns=\"http://www.w3.org/1999/xhtml\">
  <head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />
    <meta http-equiv=\"pragma\" content=\"no-cache\" />
    <title>Baen Content Manager</title>
    <base target=\"main\" />
<script type=\"text/javascript\" language=\"javascript\"><!--

var ControlVersion = '2.0.1.6';
var fonts = new Array( 'Lucida Bright,Bookman Old Style,Georgia,Times New Roman,serif', //SerifFonts
                       'Lucida Sans,Verdana,Arial,Helvetica,sans-serif',                //Sans Serif Fonts
                       'Lucida Console,Courier New,Courier,monospace');                 // Monospace Fonts
var fnt = '';
var fntIndex = 0;

var fntSize = 'medium';
var fntSizeIndex = 3;

var mainBgColor = '#ffffff';

var FirstChap = '';
var BlurbPage = '';

var origWidth = window.innerWidth;
var origHeight = window.innerHeight;

var bookIsbn= \""$sku"\";
var bookTitle= \""$title"\";
var lastPage = new Array(0"$chapterData"); \n \

window.addEventListener('message', function(event) { 
	console.log(event.data); 
}); 

function isData()
{
  return(parent != null); // Is the data module loaded
}

function isbn()
{
	if (isData()){
		try{
			return(parent.isbn);
		}catch(e){
		}
	}
	return bookIsbn;
}

function real_isbn()
{
  if (isData()) 
	{
		var real_isbn= bookIsbn;
		try{
			real_isbn= isbn().toString();
		}catch(e){
		}
		if (real_isbn.substring(0,1).toLowerCase() == \"a\")
		{
			real_isbn = real_isbn.substring(1);
		}
		return(real_isbn);
	}
}

function getCookieVal (offset) {
  var endstr = document.cookie.indexOf (\";\", offset);
  if (endstr == -1)
    endstr = document.cookie.length;
  return unescape(document.cookie.substring(offset, endstr));
}

function FixCookieDate (date) {
  var base = new Date(0);
  var skew = base.getTime(); // dawn of (Unix) time - should be 0
  if (skew > 0)  // Except on the Mac - ahead of its time
    date.setTime (date.getTime() - skew);
}

function GetCookie (name) {
  var arg = name + \"=\";
  var alen = arg.length;
  var clen = document.cookie.length;
  var i = 0;
  while (i < clen) {
    var j = i + alen;
    if (document.cookie.substring(i, j) == arg)
      return getCookieVal (j);
    i = document.cookie.indexOf(\" \", i) + 1;
    if (i == 0) break; 
  }
  return null;
}

function SetCookie (name,value,expires,path,domain,secure) {
  document.cookie = name + \"=\" + escape (value) +
    ((expires) ? \"; expires=\" + expires.toGMTString() : \"\") +
    ((path) ? \"; path=\" + path : \"\") +
    ((domain) ? \"; domain=\" + domain : \"\") +
    ((secure) ? \"; secure\" : \"\");
}

function DeleteCookie (name,path,domain) {
  if (GetCookie(name)) {
    document.cookie = name + \"=\" +
      ((path) ? \"; path=\" + path : \"\") +
      ((domain) ? \"; domain=\" + domain : \"\") +
      \"; expires=Thu, 01-Jan-70 00:00:01 GMT\";
  }
}

function expdate()
{
  var edate = new Date ();
  FixCookieDate (edate); // Correct for Mac date bug - call only once for given Date object!
  edate.setTime (edate.getTime() + (240 * 60 * 60 * 1000)); // 240 hrs from now 
  return edate;
}

function getLastPg()
{
	if (isData()){
		try{
			return(parent.lastPg);
		}catch(e){
			return(lastPage);
		}
	}
	else{ 
		return(lastPage);
	}
}
  
function TheBookTitle()
{	
	if (isData()){
		try{
			return(parent.TheBookTitle);  
		}catch(e){
			return bookTitle;
		}
	}else{
		return bookTitle;
	}
}

function GetFonts(aIndex)
{
  fntIndex = aIndex;  
  return(fonts[aIndex]);
}

function font()    
{
  return(fnt);
}

function SetFont( aIndex)
{
  if (aIndex == null) aIndex=0;

  fnt = GetFonts(aIndex);
  SetCookie('eWSFontIndex', aIndex, expdate());

  if (document.PageSelect.FontList != null)
    document.PageSelect.FontList.selectedIndex = fntIndex;

	try{
		if (parent.main)
		{
			if (parent.document.tags)
			{
				parent.main.document.location.reload(false);
			}
			else
			{
				mainLoad(parent.main.document);
			}
		}
	}catch(e){
	}
}

function fontSize()
{
  return(fntSize);
}

function SetFontSize( aIndex)
{
  if (aIndex == null) aIndex=3;

  fntSizeIndex = aIndex;
  if (document.PageSelect.fSize != null)
  {
    fntSize = document.PageSelect.fSize.options[aIndex].text;

    SetCookie('eWSFontSizeIndex', aIndex, expdate());

    document.PageSelect.fSize.selectedIndex = fntSizeIndex;
  } 
  try{
  if (parent.main)
  {
    if (parent.document.tags)
    {
      parent.main.document.location.reload(false);
    }
    else
    {
      mainLoad(parent.main.document);
    }
  }
  }catch(e){
  }
}

function GetBookTitle()
{
  return TheBookTitle();
}

function SetBookTitle(aTitle)
{
  if (isData()) parent.TheBookTitle = aTitle;
}  

function restorePage()
{
  if (parent.innerWidth)
    if (origWidth != window.innerWidth || origHeight != window.innerHeight)
    {
      history.go(0);
    }
}
  
function mainLoad(aDoc)
{
  {
    if (aDoc.body && aDoc.body.style)
    {
    	aDoc.body.style.fontSize = fontSize();
    	aDoc.body.style.fontFamily = font();
    	if (aDoc.setStyle) aDoc.setStyle();
    }
    else
    if (parent.document.tags)
    { 
      aDoc.tags.P.textIndent = \"2em\";
      aDoc.tags.P.marginTop = \"0\";
      aDoc.tags.P.marginBottom = \"2px\";
      aDoc.tags.BODY.fontSize = fontSize();
      aDoc.tags.BODY.fontFamily = font();
      aDoc.tags.TD.fontSize = fontSize();
      aDoc.tags.TD.fontFamily = font();
    }
  }
  aDoc.bgColor=mainBgColor;

  var aStr = '<html><head><title></title></head>';
  aStr += '<body bgcolor=\"#000000\" text=\"#ffc900\" style=\"font-family:Arial; padding-top:3px;\">';
  aStr += '<h5>&nbsp; ' + GetBookTitle() + ' ' + aDoc.title + '</h5>';
  aStr += '</body></html>';

  B = parent.banner.document;
  B.close();
  B.open('text/html','replace');
  B.write(aStr);
  B.close();
}

function addHeader(){
	var aStr = '<html><head><title></title></head>';
	aStr += '<body bgcolor=\"#000000\" text=\"#ffc900\" style=\"font-family:Arial; padding-top:3px;\">';
	aStr += '<h5>&nbsp; ' + GetBookTitle() + '</h5>';
	aStr += '</body></html>';

	B = parent.banner.document;
	B.close();
	B.open('text/html','replace');
	B.write(aStr);
}

function SetPage(PgNo)
{
	/*
	if (parent.document.tags) return;
  if (PgNo == null)
  { 
  	if (parent.main) parent.main.location.replace(FirstChap);
  }
  else  
  {
	  PgNo = parseInt(PgNo);
	  if (PgNo != PgNo) return;

	  document.PageSelect.PageNo.value = PgNo;
	  var ChapNo = '';
	  if ((PgNo < 0) || (PgNo > getLastPg()[getLastPg().length - 1]))
	  {
	    document.PageSelect.PageNo.value = getLastPg()[getLastPg().length - 1];      
	    alert('Page Number is out of range for this book.' 
	         +' Please Enter a Page number between 0 and ' + document.PageSelect.PageNo.value);
	    return(false);     
	  }
	  for (i=0; i < getLastPg().length; i++)
	  {
  	  if (!(i==0 && getLastPg()[0]==0))
  	  {
	      if ((PgNo > getLastPg()[i-1]) && (PgNo <= getLastPg()[i]) || ((PgNo >=0) && (PgNo <= getLastPg()[0])))
	      {
	        if (parent.main != null)
	        {
	          var str = ChapterFileName(i) + '#p' + PgNo;
  	        parent.main.location.replace(str);
	          break;
	        }  
	      }
	    }
	  }
  }
  */
  return(false);
}

function PageSelect_onsubmit() 
{
	SetPageCookie();
  return SetPage(document.PageSelect.PageNo.value);
}

function FontList_onchange() 
{
  var nItem = document.PageSelect.FontList.selectedIndex;
  SetFont(nItem);
}

function fSize_onchange() 
{
  var CookieFntSize = null;

  nItem = document.PageSelect.fSize.selectedIndex;
 
  SetFontSize(nItem);
}

function SetPageCookie() 
{
  if (document.PageSelect.PageNo == null) return;
  var aIndex = parseInt(document.PageSelect.PageNo.value);
  if (isNaN(aIndex)) return;
  SetCookie('eWS' + isbn() + 'PageNo', aIndex, expdate());
}

function ChapterFileName( nChapter )
{
  ChapNo = '_' + nChapter;
  
  	if (nChapter < 100)
 	{
  		while (ChapNo.length < 4)
  		{    
			ChapNo = '_' + ChapNo;	
  		}
	}
	else
	{
		while (ChapNo.length < 5)
  		{    
			ChapNo = '_' + ChapNo;	
  		}
	}
  return isbn() + ChapNo + '.htm';
}

function MakeIndex()
{
	try{
		if (!parent.document.tags)
		{
		var s = '<tr><th colspan=\"5\">';
		  s +='<a href=\"\" onclick=\"return SetPageCookie()\">Bookmark</a><br>';
		  s +='<input type=\"text\" name=\"PageNo\" size=\"4\" value=\"1\" ';
		  s +='onblur=\"PageSelect_onsubmit();\"'; 
		  s +='></th></tr>';
		  document.write(s);
		}
	}catch(e){
		var s = '<tr><th colspan=\"5\"><a href=\"\" onclick=\"return SetPageCookie()\">Bookmark</a><br><input type=\"text\" name=\"PageNo\" size=\"4\" value=\"1\" onblur=\"PageSelect_onsubmit();\"></th></tr>';
		document.write(s);
	}
}

var iphone_start = 0;


function MakeChapTable()
{
      var tbl = '';
      var sOut = '<tr><th colspan=\"5\" align=\"center\">Chapters</th></tr><tr>';
      var prologue = 1;
	  var lastPgData= getLastPg();
      
      if (! isData()) return(\"\");
      
      if (lastPgData[0] == 0)
	      {
	        prologue = 1;
			iphone_start = 0;
	      }
	      else
	      {
	        prologue = 0;
			iphone_start = 1;
	      }
	
      var lastPgLength= lastPgData.length;
      for (i=prologue; i < lastPgLength; i++)
      {
        tbl = '';

        if (FirstChap=='')
          FirstChap = ChapterFileName(i);
          
        tbl += '<td valign=\"top\" align=\"center\"><b>';
        tbl += '<a href=\"';
        tbl += ChapterFileName(i);
        tbl += '\" target=\"main\">';
        if (i == 0)
        {
          tbl += 'P';
        }
        else  
        {
          tbl += i;
        }
          
        tbl += '</a></b></td>';
        
        if (  ( (i-(prologue-1)) % 5) == 0 )
        {
          tbl +='</tr><tr>';
        }      
        sOut += tbl;
      } 
      while (((i-(1*prologue)) % 5) != 0)
      {
        sOut += '<td>&nbsp;</td>';
        i++;
      }
      sOut += '</tr>';

      window.document.writeln(sOut);    
}

function MakeCopyright()
{
      if (getLastPg()[0] == 0)
        prologue = 1;
      else
        prologue = 0;
        
      BlurbPage = isbn() + '__c_.htm';  
  var s =  '<tr><th colspan=\"5\">';
      s += '<p><a href=\"'+ BlurbPage + '\">Cover</a></p>';
      s += '</td></tr>';
      s += '<tr><td colspan=\"5\" align=\"center\">';
      s += '<p><a href=\"' + isbn() + '___'+ prologue + '.htm\" target=\"_top\"><b>Frameless</b></a></p>';
      s += '</td></tr>';

  document.write(s);    
}

function MakeFSize()
{
	try{
		if ( parent.document.tags || parent.document.body.style){
			var i = 8;
			var s = '<tr><td colspan=\"5\" valign=\"top\" align=\"center\">';
			s +='<select size=\"1\" name=\"fSize\" ';
			s += 'width=\"90\" ';
			s +='language=\"javascript\" onchange=\"return fSize_onchange()\">';
			s +='<option>xx-small';
			s +='<option>x-small';
			s +='<option>small';
			s +='<option>medium';
			s +='<option>large';
			s +='<option>x-large';
			s +='<option>xx-large';
			while (i < 65)
			{
			  s += '<option>'+ i + 'pt';

			  i++;

			  if (i < 12) {i++;}  

			  if ((20 < i) && (i < 24)) {i++;}

			  if ((24 < i) && (i < 64)) {i = i+7;}
			}

			s +='</select>';
			s +='</td></tr>';
			document.write(s);   
		}  
	}catch(e){
	}
}

function MakeFontList()
{
	try{
		if ( parent.document.tags || parent.document.body.style){
			var s = '<tr><td colspan=\"5\" valign=\"top\" align=\"center\">';
			s += '<select size=\"1\" name=\"FontList\" ';
			s += 'width=\"90\" ';
			s += 'language=\"javascript\" onchange=\"return FontList_onchange()\">';
			s += '<option selected value=\"serif\">serif</option>';
			s += '<option value=\"sans-serif\">sans-serif</option>';
			s += '<option value=\"monospace\">monospace</option>';
			s += '</select>';
			s += '</td></tr>';
			document.write(s);
		}
	}catch(e){
	}
}

function MakeRotator()
{
  var s = '<a href=\"http://www.baenebooks.com/ad/ebook_ad.aspx?isbn=';
      s += isbn();
      s += '&title=';
      s += TheBookTitle();
      s += '\"><img name=\"rotator\" src=\"http://www.baenebooks.com/ad/ebook_banner.aspx?isbn='
      s += isbn();
      s += '&title=';
      s += escape(TheBookTitle());
      s += '\" border=\"0\" vspace=\"5\" onerror=\"this.style.display='
      s += \"'none'\";
      s += ';\"></a>';
      document.write(s);
}
var mobile = false;

function Loaded()
{
  //if (parent.main){
    if (isData())
    {
      SetFont(GetCookie('eWSFontIndex'));
      SetFontSize(GetCookie( 'eWSFontSizeIndex'));
    }  
  //}
  var loadCookieVal= GetCookie( 'eWS' + isbn() + 'PageNo');
  var search = document.location.search;
  if(loadCookieVal==null){
	  if (search == '?blurb')
	  {
		if((navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i)) || (navigator.userAgent.match(/iPad/i))  ) 
		{
			 if (document.cookie.indexOf(\"iphone_redirect=false\") == -1) 
			{
				mobile = true;
				top.location = BlurbPage;
			}
		}
		else
		{
			main.location.replace(BlurbPage);
		}
	  }
	  else
	  {
		SetPage(GetCookie( 'eWS' + isbn() + 'PageNo'));
	  }
	}else{
		SetPage(GetCookie( 'eWS' + isbn() + 'PageNo'));
	}
}

if((mobile == true) && (search != \"?blurb\"))
	{
	
		top.location = ChapterFileName(iphone_start);

	}


window.onresize=restorePage;
window.onload = SetPageCookie;

//--></script>
		
  <style type=\"text/css\">
		body,p,td,th,input,select {font-family:Arial,Helvetica,sans-serif;}
		input,select {width:75px;font-size:11px;padding:0;text-align:center}
		td,input,select {font-size:11px;}
		th {font-size:15px}
	</style>
  </head>
  <body style=\"background-color:#FFFFFF;color:#FFFFFF; background-image: url('background.jpg'); background-repeat: no-repeat;\" link=\"#00FFFF\" vlink=\"#FFFFFF\" alink=\"#FF0000\" onload=\"Loaded()\" onresize=\"restorePage()\" onunload=\"SetPageCookie()\" >
    <form method=\"GET\" action=\"bncontrol.htm\" name=\"PageSelect\" id=\"PageSelect\" onsubmit=\"return PageSelect_onsubmit()\" target=\"main\">
      <div align=\"center\">
 
        <table border=\"1\" cellspacing=\"0\" width=\"80\">
	<BR />
<a href=\"http://www.baen.com\" onclick=\"top.location='http://www.baen.com';\">Home</a><BR/><BR/>
	
	
				<script type=\"text/javascript\" language=\"JavaScript\">
				<!-- 

				
				document.writeln('<div style=\"border-style: solid; border-width:2px; width:85px; border-color: #901237; background-color: #d9d9d9; color: #343434; height:120px; font-weight: bold; padding-top:10px;\"> Order <BR />your<BR /> copy:<a href=\"http://www.baen.com/bookdata/catalog/orderisbn/isbn/' + real_isbn() + '\" onclick=\"top.location=\'http://www.baen.com/bookdata/catalog/orderisbn/isbn/'  + real_isbn() + '\'\"><img src=\"buttonbook.png\"  border=\"0\" vspace=\"5\" /></a> <a href=\"http://www.baen.com/catalog/product/forward/sku/' + isbn() + '\" onclick=\"top.location=\'http://www.baen.com/catalog/product/forward/sku/'  + isbn() + '\'\"><img src=\"buttonebook.png\"  border=\"0\" vspace=\"0\" /></a></div>');
				
				-->
				</script>
		
	<BR />
          <script type=\"text/javascript\" language=\"JavaScript\"><!--
            MakeIndex();
            MakeChapTable();
            MakeCopyright();
            MakeFSize();
            MakeFontList();
          //--></script>
        </table>
				<script type=\"text/javascript\" language=\"JavaScript\"><!-- 
					MakeRotator(); 
					//addHeader();
					var html= document.getElementsByTagName(\"html\")[0];
					var body= document.getElementsByTagName(\"body\")[0];
					function setBannerHeight(){
						var bnHeight= body.clientHeight;
						var windowHeight= window.innerHeight;
						console.log(\"bn height: \" + bnHeight + \" window height: \" + windowHeight);
						if(bnHeight>windowHeight){
							body.style.height= windowHeight + \"px\";
							body.style.overflow= \"auto\";
							html.style.height= windowHeight + \"px\";
							html.style.overflow= \"auto\";
						}else{
							body.style.height= \"auto\";
							body.style.overflow= \"auto\";
							html.style.height= \"auto\";
							html.style.overflow= \"auto\";
						}
					}
					setBannerHeight();
					window.addEventListener(\"resize\", setBannerHeight);
				//--></script>
      </div>
    </form>
  </body>
</html>" >> $bnfile